#include <bits/stdc++.h>

using namespace std;

int main(){

    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n;

    cin >> n;

    vector<vector<int>> al(n);

    for(int i = 1; i < n; ++i){
        int u, v;

        cin >> u >> v;
        --u, --v;

        al[u].push_back(v);
        al[v].push_back(u);
    }

    vector<long long> c(n);
    vector<int> inT(n, -1), outT(n, -1);
    vector<bool> vis(n);

    for(int i = 0; i < n; ++i) cin >> c[i];

    auto total = [&](int t, auto total) -> long long {
        vis[t] = 1;

        for(int i : al[t]){
            if(vis[i]) continue;
            c[t] += total(i, total);
        }

        return c[t];
    };

    int cTm = 0, curHolder = 0;
    auto dfs = [&](int t, auto dfs) -> void {
        vis[t] = 1;
        inT[t] = ++cTm;

        for(int i : al[t]){
            if(inT[i] != -1) continue;
            dfs(i, dfs);
        }

        outT[t] = ++cTm;
    };

    vector<map<int, long long>> lazy(n);
    auto balance = [&](){

        while(true){
            long long maxImp = 0;
            int minInd = curHolder;
            for(int i : al[curHolder]){
                auto it = lazy[curHolder].begin();
                while(it != lazy[curHolder].end()){
                    if(inT[it->first] > inT[curHolder]){
                        if(inT[i] > inT[curHolder] && inT[i] <= inT[it->first] && outT[i] >= outT[it->first]){
                            c[i] += it->second;
                            if(inT[i] != inT[it->first]) lazy[i][it->first] += it->second;
                            auto tmp = it;
                            ++it;

                            lazy[curHolder].erase(tmp);
                        }else ++it;
                    }else{
                        if(inT[i] < inT[curHolder] && inT[i] >= inT[it->first] && outT[i] <= outT[it->first]){
                            c[i] += it->second;
                            if(inT[i] != inT[it->first]) lazy[i][it->first] += it->second;
                            auto tmp = it;
                            ++it;

                            lazy[curHolder].erase(tmp);
                        }else ++it;
                    }
                }

                long long imp = c[i] - (c[curHolder] - c[i]);
                if(imp > maxImp) maxImp = imp, minInd = i;
                else if(imp == maxImp && i < minInd) curHolder = i;
            }

            if(maxImp > 0 || minInd < curHolder){
                c[curHolder] -= c[minInd];
                c[minInd] += c[curHolder];
                curHolder = minInd;
            }else break;
        }

        return;
    };

    total(0, total);
    dfs(0, dfs);
    balance();
    
    cout << curHolder + 1 << '\n';

    int q;

    cin >> q;

    while(q--){
        long long a, b;

        cin >> a >> b;

        lazy[curHolder][--b] += a;
        c[curHolder] += a;
        balance();

        cout << curHolder + 1 << '\n';
    }

    return 0;
}